import 'package:admin_desktop/application/booking_statistics/booking_statistics_state.dart';
import 'package:admin_desktop/domain/di/dependency_manager.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import '../../infrastructure/services/app_helpers.dart';

class BookingStatisticsNotifier extends StateNotifier<BookingStatisticsState> {
  BookingStatisticsNotifier() : super(BookingStatisticsState());

  Future<void> selectDate(
      {DateTime? start, DateTime? end, required BuildContext context}) async {
    state = state.copyWith(startDate: start ?? DateTime.now(), endDate: end ?? DateTime.now());
    getBookingCountStatistics(context);
  }

  Future<void> getBookingCountStatistics(BuildContext context) async {
    state=state.copyWith(isLoading: true);
    final res = await bookingStatisticsRepository.getBookingCountStatistic(
        from: state.startDate ?? DateTime.now(), to: state.endDate ?? DateTime.now());
    res.when(success: (data) {
      state = state.copyWith(bookingCountStatistics: data,isLoading: false);
    }, failure: (failure, status) {
      AppHelpers.errorSnackBar(
        context,
        text: failure,
      );
    });
  }
}
